/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.screen;

import com.alexander.mutantmore.network.Messages;
import com.alexander.mutantmore.patron_pet.PatronPetUtils;
import com.alexander.mutantmore.patron_pet.player.PlayerPatronPetDataProvider;
import com.alexander.mutantmore.patron_pet.screen.OpenPatronPetScreenPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class OpenPatronPetScreenCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_PATRON = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.fail.concoctionw.not_patron").m_7220_(OpenPatronPetScreenCommand.getPatreonComponent()));

    public OpenPatronPetScreenCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"concoctionw").executes(command -> this.displayScreen((CommandSourceStack)command.getSource())));
    }

    private int displayScreen(CommandSourceStack source) throws CommandSyntaxException {
        if (source.m_230896_() != null) {
            if (PatronPetUtils.isPlayerAPatron((Player)source.m_230896_())) {
                source.m_230896_().getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).ifPresent(data -> Messages.sendToPlayer(new OpenPatronPetScreenPacket(data.getSpawnParticles(), data.getActive(), data.getPlayAudio()), source.m_230896_()));
                return 1;
            }
            throw ERROR_NOT_PATRON.create();
        }
        return 0;
    }

    public static Component getPatreonComponent() {
        MutableComponent component = Component.m_237115_((String)"command.fail.concoctionw.not_patron_here").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD).m_130938_(clickEvent -> clickEvent.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.patreon.com/alexandersfunandgames?fan_landing=true")));
        return component;
    }
}

